/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.fw.mediasvc.DeviceClassProperties;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceProperties;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

class NonHdDeviceProperties
extends MediaDeviceProperties {
    private static final String TRACE_MASKT = "XMDANHDT";
    private static final String TRACE_MASKF = "XMDANHDF";
    private static final String TRACE_MASKD = "XMDANHDD";
    private static final String DEV_DIR = "/dev/";
    private static final String RESULT_EXT = ".result";

    NonHdDeviceProperties(DeviceClassProperties deviceClassProperties) {
        super(deviceClassProperties);
        Trace.trace(TRACE_MASKT, "<> NonHdDeviceProperties.NonHdDeviceProperties(DeviceClassProperties = " + deviceClassProperties + ")");
    }

    void setMountPoint(String mountPoint) {
        Trace.trace(TRACE_MASKT, "-> NonHdDeviceProperties.setMountPoint(mountPoint = " + mountPoint + ")");
        String buffer = null;
        try {
            FileReader tfr = new FileReader("/etc/fstab");
            BufferedReader tbr = new BufferedReader(tfr);
            while ((buffer = tbr.readLine()) != null && buffer.indexOf(this.deviceFile) == -1 && (this.deviceFileSymLink == null || buffer.indexOf(this.deviceFileSymLink) == -1)) {
            }
            tfr.close();
            if (buffer != null) {
                StringTokenizer st = new StringTokenizer(buffer);
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    this.mountPoint = st.nextToken();
                }
            } else {
                this.mountPoint = "";
            }
            Trace.trace(TRACE_MASKF, "NonHdDeviceProperties.setMountPoint(): mountPoint = " + this.mountPoint);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKT, "<- NonHdDeviceProperties.setMountPoint()");
    }

    void setDeviceFile(String deviceFileName) throws MediaDeviceException {
        Trace.trace(TRACE_MASKT, "-> NonHdDeviceProperties.setDeviceFile(deviceFileName = " + deviceFileName + ")");
        String tempFile = this.mediaServicesParameters.getParm("media.temp.dir") + deviceFileName + RESULT_EXT;
        Trace.trace(TRACE_MASKF, "NonHdDeviceProperties.setDeviceFile(): tempFile = " + tempFile);
        int rc = -1;
        try {
            String[] deviceFileCmd = new String[]{this.mediaServicesParameters.getParm("media.device.file.script"), deviceFileName, tempFile, this.mediaServicesParameters.getParm("media.log.dir") + this.mediaServicesParameters.getParm("media.log")};
            Trace.trace(TRACE_MASKF, "NonHdDeviceProperties.setDeviceFile(): deviceFileCmd[0] = " + deviceFileCmd[0]);
            Trace.trace(TRACE_MASKF, "NonHdDeviceProperties.setDeviceFile(): deviceFileCmd[1] = " + deviceFileCmd[1]);
            Trace.trace(TRACE_MASKF, "NonHdDeviceProperties.setDeviceFile(): deviceFileCmd[2] = " + deviceFileCmd[2]);
            Trace.trace(TRACE_MASKF, "NonHdDeviceProperties.setDeviceFile(): deviceFileCmd[3] = " + deviceFileCmd[3]);
            rc = RootProcess.executeProgram(deviceFileCmd);
            Trace.trace(TRACE_MASKF, "NonHdDeviceProperties.setDeviceFile(): rc = " + rc);
            if (rc == -1) {
                throw new IOException("error occurred in the device file script, return code of: " + rc);
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            MediaDeviceException mdexc = new MediaDeviceException(exc);
            throw mdexc;
        }
        if (rc == 1) {
            Trace.trace(TRACE_MASKF, "NonHdDeviceProperties.setDeviceFile(): No symbolic link exists for the device");
            this.deviceFile = DEV_DIR + deviceFileName;
            Trace.trace(TRACE_MASKF, "NonHdDeviceProperties.setDeviceFile(): deviceFileName = " + deviceFileName);
            Trace.trace(TRACE_MASKF, "NonHdDeviceProperties.setDeviceFile(): deviceFile = " + this.deviceFile);
            this.deviceFileSymLink = null;
        } else {
            Trace.trace(TRACE_MASKF, "NonHdDeviceProperties.setDeviceFile(): A symbolic link exists for the device");
            try {
                String buffer = null;
                FileReader tfr = new FileReader(tempFile);
                BufferedReader tbr = new BufferedReader(tfr);
                buffer = tbr.readLine();
                if (buffer != null) {
                    String token;
                    Trace.trace(TRACE_MASKF, "NonHdDeviceProperties.setDeviceFile(): The temp file, " + tempFile + " was NOT empty.");
                    StringTokenizer st = new StringTokenizer(buffer);
                    int numTokens = st.countTokens();
                    for (int i = 0; i < numTokens && !(token = st.nextToken()).equals("->"); ++i) {
                    }
                    this.deviceFileSymLink = DEV_DIR + deviceFileName;
                    this.deviceFile = st.nextToken();
                    Trace.trace(TRACE_MASKD, "NonHdDeviceProperties.setDeviceFile(): deviceFile = " + this.deviceFile);
                    if (this.deviceFile.startsWith("/")) {
                        Trace.trace(TRACE_MASKF, "NonHdDeviceProperties.setDeviceFile(): The device file is linked to an absolute path, deviceFile = " + this.deviceFile);
                    } else {
                        Trace.trace(TRACE_MASKF, "NonHdDeviceProperties.setDeviceFile(): The device file is linked to a relative path, the old deviceFile = " + this.deviceFile);
                        this.deviceFile = DEV_DIR + this.deviceFile;
                        Trace.trace(TRACE_MASKF, "NonHdDeviceProperties.setDeviceFile(): Setting the new device file deviceFile = " + this.deviceFile);
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "NonHdDeviceProperties.setDeviceFile(): The temp file, " + tempFile + " was empty.");
                    tfr.close();
                    throw new IOException("Empty temp file, " + tempFile);
                }
                tfr.close();
            }
            catch (IOException exc) {
                MediaDeviceException mdexc = new MediaDeviceException(exc);
                throw mdexc;
            }
        }
        this.setMountPoint(null);
        this.setInternalName();
        Trace.trace(TRACE_MASKT, "<- NonHdDeviceProperties.setDeviceFile()");
    }
}

